<?php
/**
 * Rental Settings for Archive
 *
 * @package Mytravel/ACF/Settings/RentalDetails
 */

acf_add_local_field_group(
	array(
		'key'                   => 'group_61c459f30e600',
		'title'                 => 'Rental Details',
		'fields'                => array(
			array(
				'key'               => 'field_61c459fca562c',
				'label'             => 'General',
				'name'              => '',
				'type'              => 'tab',
				'instructions'      => '',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id'    => '',
				),
				'placement'         => 'left',
				'endpoint'          => 0,
			),
			array(
				'key'               => 'field_61c45a09cc0ff',
				'label'             => 'Layout',
				'name'              => 'rental_layout',
				'type'              => 'select',
				'instructions'      => '',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id'    => '',
				),
				'choices'           => array(
					'v1' => 'v1',
					'v2' => 'v2',
				),
				'default_value'     => 'v1',
				'allow_null'        => 0,
				'multiple'          => 0,
				'ui'                => 0,
				'return_format'     => 'value',
				'ajax'              => 0,
				'placeholder'       => '',
			),
			array(
				'key'               => 'field_61c46c9ea616d',
				'label'             => 'Area Size',
				'name'              => 'area',
				'type'              => 'text',
				'instructions'      => 'Enter the area size',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id'    => '',
				),
				'default_value'     => '',
				'placeholder'       => '',
				'prepend'           => '',
				'append'            => '',
				'maxlength'         => '',
			),
			array(
				'key'               => 'field_61c46cc686ce2',
				'label'             => 'Number of Bed',
				'name'              => 'total_beds',
				'type'              => 'text',
				'instructions'      => '',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id'    => '',
				),
				'default_value'     => '',
				'placeholder'       => '',
				'prepend'           => '',
				'append'            => '',
				'maxlength'         => '',
			),
			array(
				'key'               => 'field_61c46cd386ce3',
				'label'             => 'Number of Bathroom',
				'name'              => 'total_bathrooms',
				'type'              => 'text',
				'instructions'      => '',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id'    => '',
				),
				'default_value'     => '',
				'placeholder'       => '',
				'prepend'           => '',
				'append'            => '',
				'maxlength'         => '',
			),
			array(
				'key'               => 'field_61c46ce486ce4',
				'label'             => 'Number of Rooms',
				'name'              => 'total_rooms',
				'type'              => 'text',
				'instructions'      => '',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id'    => '',
				),
				'default_value'     => '',
				'placeholder'       => '',
				'prepend'           => '',
				'append'            => '',
				'maxlength'         => '',
			),
			array(
				'key'               => 'field_60ba7e364cab6',
				'label'             => 'Amenities',
				'name'              => '',
				'type'              => 'tab',
				'instructions'      => '',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id'    => '',
				),
				'placement'         => 'left',
				'endpoint'          => 0,
			),
			array(
				'key'               => 'field_60ba7e434cab7',
				'label'             => 'Amenities',
				'name'              => 'amenities',
				'type'              => 'taxonomy',
				'instructions'      => 'Select the amenities available at the property.',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id'    => '',
				),
				'taxonomy'          => 'pa_property-facilities',
				'field_type'        => 'checkbox',
				'add_term'          => 1,
				'save_terms'        => 0,
				'load_terms'        => 0,
				'return_format'     => 'object',
				'multiple'          => 0,
				'allow_null'        => 0,
			),
			array(
				'key'               => 'field_61c45fc612893',
				'label'             => 'Location',
				'name'              => '',
				'type'              => 'tab',
				'instructions'      => '',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id'    => '',
				),
				'placement'         => 'left',
				'endpoint'          => 0,
			),
			array(
				'key'               => 'field_61c45fd5f53b5',
				'label'             => 'Location',
				'name'              => 'display_location',
				'type'              => 'text',
				'instructions'      => 'Location information that you want to display in the Rental list and Single page. Please note that this is for display purpose only and is not used in filters. Use Attributes for filtering purposes.',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id'    => '',
				),
				'default_value'     => '',
				'placeholder'       => '',
				'prepend'           => '',
				'append'            => '',
				'maxlength'         => '',
			),
			array(
				'key'               => 'field_61c4616e2d38f',
				'label'             => 'Location Map',
				'name'              => 'location_map',
				'type'              => 'google_map',
				'instructions'      => '',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id'    => '',
				),
				'center_lat'        => '',
				'center_lng'        => '',
				'zoom'              => '',
				'height'            => '',
			),
			array(
				'key'               => 'field_61c5f9d385486',
				'label'             => 'Location Tags',
				'name'              => 'location_tags',
				'type'              => 'taxonomy',
				'instructions'      => '',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id'    => '',
				),
				'taxonomy'          => 'pa_location-tags',
				'field_type'        => 'checkbox',
				'add_term'          => 1,
				'save_terms'        => 0,
				'load_terms'        => 0,
				'return_format'     => 'object',
				'multiple'          => 0,
				'allow_null'        => 0,
			),
			array(
				'key'               => 'field_61c48d3a218aa',
				'label'             => 'Video',
				'name'              => '',
				'type'              => 'tab',
				'instructions'      => '',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id'    => '',
				),
				'placement'         => 'left',
				'endpoint'          => 0,
			),
			array(
				'key'               => 'field_61c7e5ac3a8e1',
				'label'             => 'Image',
				'name'              => 'video_image',
				'type'              => 'image',
				'instructions'      => 'Applicable only for style v2',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id'    => '',
				),
				'return_format'     => 'array',
				'preview_size'      => 'medium',
				'library'           => 'all',
				'min_width'         => '',
				'min_height'        => '',
				'min_size'          => '',
				'max_width'         => '',
				'max_height'        => '',
				'max_size'          => '',
				'mime_types'        => '',
			),
			array(
				'key'               => 'field_61c48d47218ab',
				'label'             => 'Video',
				'name'              => 'video',
				'type'              => 'url',
				'instructions'      => '',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id'    => '',
				),
				'default_value'     => '',
				'placeholder'       => '',
			),
			array(
				'key'               => 'field_61c471ffa0a4c',
				'label'             => 'Details',
				'name'              => '',
				'type'              => 'tab',
				'instructions'      => '',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id'    => '',
				),
				'placement'         => 'left',
				'endpoint'          => 0,
			),
			array(
				'key'               => 'field_61c47ce91b70b',
				'label'             => 'Price List',
				'name'              => 'price_list',
				'type'              => 'textarea',
				'instructions'      => 'Enter each price list in a separate line.',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id'    => '',
				),
				'default_value'     => '',
				'placeholder'       => '',
				'maxlength'         => '',
				'rows'              => '',
				'new_lines'         => '',
			),
			array(
				'key'               => 'field_61c47d061b70c',
				'label'             => 'Terms & rules',
				'name'              => 'terms_&_rules',
				'type'              => 'textarea',
				'instructions'      => 'Enter each terms & rules in a separate line.',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id'    => '',
				),
				'default_value'     => '',
				'placeholder'       => '',
				'maxlength'         => '',
				'rows'              => '',
				'new_lines'         => '',
			),
			array(
				'key'               => 'field_61c47d3d1b70d',
				'label'             => 'Not Allowed',
				'name'              => 'not_allowed',
				'type'              => 'textarea',
				'instructions'      => 'Enter each don\'ts in a separate line.',
				'required'          => 0,
				'conditional_logic' => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id'    => '',
				),
				'default_value'     => '',
				'placeholder'       => '',
				'maxlength'         => '',
				'rows'              => '',
				'new_lines'         => '',
			),
		),
		'location'              => array(
			array(
				array(
					'param'    => 'post_type',
					'operator' => '==',
					'value'    => 'product',
				),
				array(
					'param'    => 'post_taxonomy',
					'operator' => '==',
					'value'    => 'product_format:product-format-rental',
				),
			),
		),
		'menu_order'            => 0,
		'position'              => 'normal',
		'style'                 => 'default',
		'label_placement'       => 'top',
		'instruction_placement' => 'label',
		'hide_on_screen'        => '',
		'active'                => true,
		'description'           => '',
		'show_in_rest'          => 0,
	)
);

