<?php

namespace Hostinger\Admin;

use Hostinger\Helper;

defined( 'ABSPATH' ) || exit;

/**
 * Class Hostinger_Admin_Assets
 *
 * Handles the enqueueing of styles and scripts for the Hostinger admin pages.
 */
class Assets {
	/**
	 * @var Helper Instance of the Hostinger_Helper class.
	 */
	private Helper $helper;

	public function __construct() {
		$this->helper = new Helper();
		add_action( 'admin_enqueue_scripts', array( $this, 'admin_styles' ) );
		add_action( 'admin_enqueue_scripts', array( $this, 'admin_scripts' ) );
	}

	/**
	 * Enqueues styles for the Hostinger admin pages.
	 */
	public function admin_styles(): void {
		if ( $this->helper->is_hostinger_admin_page() ) {
			wp_enqueue_style( 'hostinger_main_styles', HOSTINGER_ASSETS_URL . '/css/main.css', array(), HOSTINGER_VERSION );

			if ( Helper::show_woocommerce_onboarding() ) {
				wp_enqueue_style( 'hostinger_woo_onboarding', HOSTINGER_ASSETS_URL . '/css/woo-onboarding.css', array(), HOSTINGER_VERSION );
			}
		}

		wp_enqueue_style( 'hostinger_global_styles', HOSTINGER_ASSETS_URL . '/css/global.css', array(), HOSTINGER_VERSION );

		if ( $this->helper->is_preview_domain() && is_user_logged_in() ) {
			wp_enqueue_style( 'hostinger-preview-styles', HOSTINGER_ASSETS_URL . '/css/hts-preview.css', array(), HOSTINGER_VERSION );
		}
	}

	/**
	 * Enqueues scripts for the Hostinger admin pages.
	 */
	public function admin_scripts(): void {
		if ( $this->helper->is_hostinger_admin_page() ) {
			wp_enqueue_script(
				'hostinger_main_scripts',
				HOSTINGER_ASSETS_URL . '/js/main.js',
				array(
					'jquery',
					'wp-i18n',
				),
				HOSTINGER_VERSION,
				false
			);

			if ( Helper::show_woocommerce_onboarding() ) {
				wp_enqueue_script(
					'hostinger_woo_onboarding',
					HOSTINGER_ASSETS_URL . '/js/woo-onboarding.js',
					array(
						'jquery',
						'wp-i18n',
					),
					HOSTINGER_VERSION,
					false
				);
			}
		}

		wp_enqueue_script(
			'hostinger_global_scripts',
			HOSTINGER_ASSETS_URL . '/js/global-scripts.js',
			array(
				'jquery',
				'wp-i18n',
			),
			HOSTINGER_VERSION,
			false
		);

		if ( ! empty( Helper::get_api_token() ) ) {
			wp_enqueue_script(
				'hostinger_requests_scripts',
				HOSTINGER_ASSETS_URL . '/js/requests.js',
				array(
					'jquery',
					'wp-i18n',
				),
				HOSTINGER_VERSION,
				array( 'strategy' => 'defer' )
			);
			wp_localize_script(
				'hostinger_requests_scripts',
				'hostingerContainer',
				array(
					'url'   => admin_url( 'admin-ajax.php' ),
					'nonce' => wp_create_nonce( 'hts-ajax-nonce' ),
				)
			);
		}
	}
}
